<?php
	
	namespace UltimatePostKit\Modules\ClassicList\Widgets;
	
	use Elementor\Controls_Manager;
	use Elementor\Group_Control_Border;
	use Elementor\Group_Control_Box_Shadow;
	use Elementor\Group_Control_Typography;
	use Elementor\Group_Control_Text_Shadow;
	use Elementor\Group_Control_Image_Size;
	use Elementor\Group_Control_Background;
	
	use UltimatePostKit\Traits\Global_Widget_Controls;
	use UltimatePostKit\Traits\Global_Widget_Functions;
	use UltimatePostKit\Includes\Controls\GroupQuery\Group_Control_Query;
	use UltimatePostKit\Modules\QueryControl\Controls\Group_Control_Posts;
	use WP_Query;
	
	if ( ! defined( 'ABSPATH' ) ) {
		exit;
	} // Exit if accessed directly
	
	class Classic_List extends Group_Control_Query {

		use Global_Widget_Controls;
		use Global_Widget_Functions;

		private $_query = null;
		
		public function get_name() {
			return 'upk-classic-list';
		}
		
		public function get_title() {
			return BDTUPK . esc_html__( 'Classic List', 'ultimate-post-kit' );
		}
		
		public function get_icon() {
			return 'upk-widget-icon upk-icon-classic-list';
		}
		
		public function get_categories() {
			return [ 'ultimate-post-kit-pro' ];
		}
		
		public function get_keywords() {
			return [ 'post', 'featured', 'blog', 'recent', 'news', 'classic', 'list' ];
		}
		
		public function get_style_depends() {
			if ( $this->upk_is_edit_mode() ) {
				return [ 'upk-all-styles' ];
			} else {
				return [ 'ultimate-post-kit-font', 'upk-classic-list' ];
			}
		}
		
		public function get_custom_help_url() {
			return 'https://youtu.be/A6z4z_Ki1kw';
		}
		
		public function on_import( $element ) {
			if ( ! get_post_type_object( $element['settings']['posts_post_type'] ) ) {
				$element['settings']['posts_post_type'] = 'post';
			}
			
			return $element;
		}
		
		public function on_export( $element ) {
			$element = Group_Control_Posts::on_export_remove_setting_from_element( $element, 'posts' );
			
			return $element;
		}
		
		public function get_query() {
			return $this->_query;
		}
		
		protected function register_controls() {
			$this->start_controls_section(
				'section_content_layout',
				[
					'label' => esc_html__( 'Layout', 'ultimate-post-kit' ),
				]
			);

			$this->add_responsive_control(
				'item_gap',
				[
					'label'     => esc_html__( 'Item Gap', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item' => 'margin-top: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_image_height',
				[
					'label'     => esc_html__( 'Featured Image Height', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 200,
							'max' => 600,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-image-wrap .upk-img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_image_size',
				[
					'label'     => esc_html__( 'List Image Width', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 100,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(n+2) .upk-image-wrap' => 'width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'image_position',
				[
					'label'   => __( 'Image Position', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::CHOOSE,
					'default' => 'left',
					'options' => [
						'left'   => [
							'title' => __( 'Left', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-left',
						],
						'right'  => [
							'title' => __( 'Right', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-right',
						],
					],
					'prefix_class' => 'upk-img-position--',
					'render_type' => 'template',
					'toggle' => false
				]
			);
			
			$this->add_responsive_control(
				'content_alignment',
				[
					'label'   => __( 'Alignment', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'left'   => [
							'title' => __( 'Left', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-left',
						],
						'center'   => [
							'title' => __( 'Center', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-right',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-content' => 'text-align: {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name'    => 'primary_thumbnail',
					'exclude' => [ 'custom' ],
					'default' => 'medium',
				]
			);

			$this->add_control(
				'featured_content_into_image',
				[
					'label'   => esc_html__( 'Featured Content Into Image', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SWITCHER,
					'prefix_class' => 'upk-content-into-image--',
					'render_type' => 'template',
				]
			);
			
			$this->end_controls_section();
			
			// Query Settings
			$this->start_controls_section(
				'section_post_query_builder',
				[
					'label' => __( 'Query', 'ultimate-post-kit' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'item_limit',
				[
					'label'   => esc_html__( 'Item Limit', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SLIDER,
					'range'   => [
						'px' => [
							'min' => 1,
							'max' => 20,
						],
					],
					'default' => [
						'size' => 4,
					],
				]
			);
			
			$this->register_query_builder_controls();
			
			$this->end_controls_section();

			$this->start_controls_section(
				'section_additional_settings',
				[
					'label' => esc_html__( 'Additional Settings', 'ultimate-post-kit' ),
				]
			);
			
			//Global Title Controls
			$this->register_title_controls();

			$this->add_control(
				'show_excerpt',
				[
					'label'   => esc_html__( 'Show Text', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'separator' => 'before'
				]
			);
	
			$this->add_control(
				'excerpt_length',
				[
					'label'       => esc_html__( 'Text Limit', 'ultimate-post-kit' ),
					'description' => esc_html__('It\'s just work for main content, but not working with excerpt. If you set 0 so you will get full main content.', 'ultimate-post-kit'),
					'type'        => Controls_Manager::NUMBER,
					'default'     => 15,
					'condition'   => [
						'show_excerpt' => 'yes'
					],
				]
			);
	
			$this->add_control(
				'strip_shortcode',
				[
					'label'     => esc_html__('Strip Shortcode', 'ultimate-post-kit'),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'condition' => [
						'show_excerpt' => 'yes',
					],
				]
			);
			
			$this->add_control(
				'show_category',
				[
					'label'   => esc_html__( 'Show Category', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'show_author',
				[
					'label'     => esc_html__( 'Show Author', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'show_comments',
				[
					'label' => esc_html__( 'Show Comments', 'ultimate-post-kit' ),
					'type'  => Controls_Manager::SWITCHER,
				]
			);
			
			$this->add_control(
				'meta_separator',
				[
					'label'       => __( 'Separator', 'ultimate-post-kit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => '//',
					'label_block' => false,
				]
			);
			
			//Global Date Controls
			$this->register_date_controls();
			
			$this->add_control(
				'show_pagination',
				[
					'label'     => esc_html__( 'Show Pagination', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'global_link',
				[
					'label'        => __( 'Item Wrapper Link', 'ultimate-post-kit' ),
					'type'         => Controls_Manager::SWITCHER,
					'prefix_class' => 'upk-global-link-',
					'description'  => __( 'Be aware! When Item Wrapper Link activated then title link and read more link will not work', 'ultimate-post-kit' ),
				]
			);

			$this->end_controls_section();
		
			//Style
			$this->start_controls_section(
				'upk_section_style',
				[
					'label' => esc_html__( 'Item', 'ultimate-post-kit' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			$this->start_controls_tabs( 'tabs_item_style' );
			
			$this->start_controls_tab(
				'tab_item_normal',
				[
					'label' => esc_html__( 'Normal', 'ultimate-post-kit' ),
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'item_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item',
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'        => 'item_border',
					'label'       => __('Border', 'ultimate-post-kit'),
					'placeholder' => '1px',
					'default'     => '1px',
					'selector'    => '{{WRAPPER}} .upk-classic-list .upk-item',
				]
			);

			$this->add_responsive_control(
				'item_border_radius',
				[
					'label'      => esc_html__('Border Radius', 'ultimate-post-kit'),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%'],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label'      => esc_html__( 'Padding', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_featured_padding',
				[
					'label'      => esc_html__( 'Featured Padding', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'item_box_shadow',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_item_hover',
				[
					'label' => esc_html__( 'Hover', 'ultimate-post-kit' ),
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'item_hover_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item:hover',
				]
			);

			$this->add_control(
				'item_border_hover_color',
				[
					'label'     => esc_html__( 'Border Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:hover' => 'border-color: {{VALUE}};',
					],
					'condition' => [
						'item_border_border!' => ''
					]
				]
			);

			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'item_hover_box_shadow',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item:hover',
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_image',
				[
					'label'     => esc_html__( 'Image', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
				]
			);
			
			$this->add_control(
				'item_overlay_color',
				[
					'label'     => esc_html__( 'Overlay Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-image-wrap:before' => 'background: linear-gradient(0deg, {{VALUE}} 0, rgba(141, 153, 174, 0.1) 100%);',
					],
					'condition' => [
						'featured_content_into_image' => 'yes'
					]
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'item_image_border',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-image-wrap',
				]
			);
			
			$this->add_responsive_control(
				'item_image_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-image-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_title',
				[
					'label'     => esc_html__( 'Title', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_title' => 'yes',
					],
				]
			);
			
			$this->add_control(
				'title_style',
				[
					'label'   => esc_html__( 'Style', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'underline',
					'options' => [
						'underline'        => esc_html__( 'Underline', 'ultimate-post-kit' ),
						'middle-underline' => esc_html__( 'Middle Underline', 'ultimate-post-kit' ),
						'overline'         => esc_html__( 'Overline', 'ultimate-post-kit' ),
						'middle-overline'  => esc_html__( 'Middle Overline', 'ultimate-post-kit' ),
					],
				]
			);
			
			$this->add_control(
				'title_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-title a' => 'color: {{VALUE}};',
					],
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'title_hover_color',
				[
					'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-title a:hover' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'title_classic_color',
				[
					'label'     => esc_html__( 'Featured Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-title a' => 'color: {{VALUE}};',
					],
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'title_classic_hover_color',
				[
					'label'     => esc_html__( 'Featured Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-title a:hover' => 'color: {{VALUE}};',
					],
					'separator' => 'after'
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-title',
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'featured_title_typography',
					'label'    => esc_html__( 'Featured Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-title',
				]
			);
			
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'title_text_shadow',
					'label'    => __( 'Text Shadow', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-title a',
				]
			);
			
			$this->end_controls_section();

			$this->start_controls_section(
				'section_style_text',
				[
					'label'     => esc_html__( 'Text', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_excerpt' => 'yes',
					],
				]
			);
	
			$this->add_control(
				'text_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-text' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'text_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-text',
				]
			);
	
			$this->add_responsive_control(
				'text_margin',
				[
					'label' 	 => __('Margin', 'ultimate-post-kit'),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
	
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_meta',
				[
					'label'      => esc_html__( 'Meta', 'ultimate-post-kit' ),
					'tab'        => Controls_Manager::TAB_STYLE,
					'conditions' => [
						'relation' => 'or',
						'terms'    => [
							[
								'name'  => 'show_author',
								'value' => 'yes'
							],
							[
								'name'  => 'show_date',
								'value' => 'yes'
							],
							[
								'name'  => 'show_comments',
								'value' => 'yes'
							]
						]
					],
				]
			);
			
			$this->add_control(
				'meta_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-meta, {{WRAPPER}} .upk-classic-list .upk-item .upk-meta .upk-author-wrap .upk-author-name' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'meta_classic_color',
				[
					'label'     => esc_html__( 'Featured Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-meta, {{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-meta .upk-author-wrap .upk-author-name' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'meta_spacing',
				[
					'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-meta' => 'padding-top: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'meta_space_between',
				[
					'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-meta .upk-separator' => 'margin: 0 {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'meta_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-meta',
				]
			);
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_category',
				[
					'label'     => esc_html__( 'Category', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_category' => 'yes',
					],
				]
			);
			
			$this->add_responsive_control(
				'category_bottom_spacing',
				[
					'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->start_controls_tabs( 'tabs_category_style' );
			
			$this->start_controls_tab(
				'tab_category_normal',
				[
					'label' => esc_html__( 'Normal', 'ultimate-post-kit' ),
				]
			);
			
			$this->add_control(
				'category_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'category_classic_color',
				[
					'label'     => esc_html__( 'Featured Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-category a' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'category_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-category a',
				]
			);

			$this->add_control(
				'featured_bg_color',
				[
					'label'     => esc_html__( 'Featured Background', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'separator' => 'before'
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'featured_category_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-category a',
					'condition' => [
						'featured_bg_color' => 'yes'
					]
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'category_border',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-category a',
					'separator' => 'before'
				]
			);
			
			$this->add_responsive_control(
				'category_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'category_padding',
				[
					'label'      => esc_html__( 'Padding', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'category_spacing',
				[
					'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min'  => 0,
							'max'  => 50,
							'step' => 2,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a+a' => 'margin-left: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'category_shadow',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-category a',
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'category_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-category a',
				]
			);
			
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'tab_category_hover',
				[
					'label' => esc_html__( 'Hover', 'ultimate-post-kit' ),
				]
			);
			
			$this->add_control(
				'category_hover_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a:hover' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'category_classic_color_hover',
				[
					'label'     => esc_html__( 'Featured Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-category a:hover' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'category_hover_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item .upk-category a:hover',
				]
			);

			$this->add_control(
				'category_featured_heading',
				[
					'label'     => esc_html__( 'Featured Background', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::HEADING,
					'condition' => [
						'featured_bg_color' => 'yes'
					],
					'separator' => 'before'
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'featured_hover_category_background',
					'selector' => '{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-category a:hover',
					'condition' => [
						'featured_bg_color' => 'yes'
					]
				]
			);
			
			$this->add_control(
				'category_hover_border_color',
				[
					'label'     => esc_html__( 'Border Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'category_border_border!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item .upk-category a:hover' => 'border-color: {{VALUE}};',
					],
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'featured_category_hover_border_color',
				[
					'label'     => esc_html__( 'Featured Border Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'category_border_border!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .upk-classic-list .upk-item:nth-child(1) .upk-category a:hover' => 'border-color: {{VALUE}};',
					],
				]
			);
			
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			
			$this->end_controls_section();
		
			//Global Pagination Controls
			$this->register_pagination_controls();
		}
		
		/**
		 * Main query render for this widget
		 * @param $posts_per_page number item query limit
		 */
		public function query_posts( $posts_per_page ) {
			
			$default = $this->getGroupControlQueryArgs();
			if ( $posts_per_page ) {
				$args['posts_per_page'] = $posts_per_page;
				$args['paged']  = max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) );
			}
			$args         = array_merge( $default, $args );
			$this->_query = new WP_Query( $args );
		}
		
		public function render_author() {
			
			if ( ! $this->get_settings( 'show_author' ) ) {
				return;
			}
			?>
            <div class="upk-author-wrap">
                <span class="upk-by"><?php echo esc_html_x( 'by', 'Frontend', 'ultimate-post-kit' ) ?></span>
                <a class="upk-author-name" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ) ?>">
					<?php echo get_the_author() ?>
                </a>
            </div>
			<?php
		}
		
		public function render_comments( $id = 0 ) {
			
			if ( ! $this->get_settings( 'show_comments' ) ) {
				return;
			}
			?>

            <div class="upk-classic-comments">
				<?php echo get_comments_number( $id ) ?>
				<?php echo esc_html_x( 'Comments', 'Frontend', 'ultimate-post-kit' ) ?>
            </div>
			
			<?php
		}

		public function render_post_grid_item( $post_id, $image_size, $excerpt_length ) {
			$settings = $this->get_settings_for_display();
			
			if ( 'yes' == $settings['global_link'] ) {
				
				$this->add_render_attribute( 'list-item', 'onclick', "window.open('" . esc_url( get_permalink() ) . "', '_self')", true );
			}
			$this->add_render_attribute( 'list-item', 'class', 'upk-item', true );
			
			?>
            <div <?php $this->print_render_attribute_string( 'list-item' ); ?>>
                <div class="upk-item-box">
					<div class="upk-image-wrap">
						<?php $this->render_image( get_post_thumbnail_id( $post_id ), $image_size ); ?>
					</div>
                    <div class="upk-content">
						<?php $this->render_category(); ?>
						<?php $this->render_title(); ?>
						<?php $this->render_excerpt($excerpt_length); ?>
						
						<?php if ( $settings['show_author'] or $settings['show_comments'] or $settings['show_date'] ) : ?>
							<div class="upk-meta">
								<?php if ( $settings['show_author'] ) : ?>
									<?php $this->render_author(); ?>
									<?php if(!empty($settings['meta_separator'])) : ?>
									<span class="upk-separator"><?php echo $settings['meta_separator']; ?></span>
									<?php endif; ?>
								<?php endif; ?>
								<?php $this->render_date(); ?>
								<?php if ( $settings['show_comments'] ) : ?>
									<?php if(!empty($settings['meta_separator'])) : ?>
									<span class="upk-separator"><?php echo $settings['meta_separator']; ?></span>
									<?php endif; ?>
									<?php $this->render_comments( $post_id ); ?>
								<?php endif; ?>
							</div>
						<?php endif; ?>
                    </div>

                </div>
            </div>
			
			<?php
		}
		
		protected function render() {
			$settings = $this->get_settings_for_display();
			
			$this->query_posts( $settings['item_limit']['size'] );
			$wp_query = $this->get_query();
			
			if ( ! $wp_query->found_posts ) {
				return;
			}

			$this->add_render_attribute( 'list-wrap', 'class', 'upk-classic-list' );
		
			if (isset($settings['upk_in_animation_show']) && ($settings['upk_in_animation_show'] == 'yes')) {
				$this->add_render_attribute( 'list-wrap', 'class', 'upk-in-animation' );
				if (isset($settings['upk_in_animation_delay']['size'])) {
					$this->add_render_attribute( 'list-wrap', 'data-in-animation-delay', $settings['upk_in_animation_delay']['size'] );
				}
			}
			
			?>
            <div <?php $this->print_render_attribute_string('list-wrap'); ?>>
				<?php while ( $wp_query->have_posts() ) :
					$wp_query->the_post();
					
					$thumbnail_size = $settings['primary_thumbnail_size'];
					
					?>
					
					<?php $this->render_post_grid_item( get_the_ID(), $thumbnail_size, $settings['excerpt_length'] ); ?>
				
				<?php endwhile; ?>
            </div>
			
			<?php
			
			if ( $settings['show_pagination'] ) { ?>
                <div class="ep-pagination">
					<?php ultimate_post_kit_post_pagination($wp_query, $this->get_id()); ?>
                </div>
				<?php
			}
			wp_reset_postdata();
		}
	}
