<?php
	
	namespace UltimatePostKit\Modules\WixerGrid\Widgets;
	
	use Elementor\Controls_Manager;
	use Elementor\Group_Control_Border;
	use Elementor\Group_Control_Box_Shadow;
	use Elementor\Group_Control_Typography;
	use Elementor\Group_Control_Text_Shadow;
	use Elementor\Group_Control_Image_Size;
	use Elementor\Group_Control_Background;
	
	use UltimatePostKit\Traits\Global_Widget_Controls;
	use UltimatePostKit\Traits\Global_Widget_Functions;
	use UltimatePostKit\Includes\Controls\GroupQuery\Group_Control_Query;
	use UltimatePostKit\Modules\QueryControl\Controls\Group_Control_Posts;
	use WP_Query;
	
	if ( ! defined( 'ABSPATH' ) ) {
		exit;
	} // Exit if accessed directly
	
	class Wixer_Grid extends Group_Control_Query {
		
	    use Global_Widget_Controls;
	    use Global_Widget_Functions;
		
		private $_query = null;
		
		public function get_name() {
			return 'upk-wixer-grid';
		}
		
		public function get_title() {
			return BDTUPK . esc_html__( 'Wixer Grid', 'ultimate-post-kit' );
		}
		
		public function get_icon() {
			return 'upk-widget-icon upk-icon-wixer-grid';
		}
		
		public function get_categories() {
			return [ 'ultimate-post-kit-pro' ];
		}
		
		public function get_keywords() {
			return [ 'post', 'grid', 'blog', 'recent', 'news', 'alex' ];
		}
		
		public function get_style_depends() {
			if ( $this->upk_is_edit_mode() ) {
				return [ 'upk-all-styles' ];
			} else {
				return [ 'ultimate-post-kit-font', 'upk-wixer-grid' ];
			}
		}
		
		public function get_custom_help_url() {
			return 'https://youtu.be/MeR0jXdpYc0';
		}
		
		public function on_import( $element ) {
			if ( ! get_post_type_object( $element['settings']['posts_post_type'] ) ) {
				$element['settings']['posts_post_type'] = 'post';
			}
			
			return $element;
		}
		
		public function on_export( $element ) {
			$element = Group_Control_Posts::on_export_remove_setting_from_element( $element, 'posts' );
			return $element;
		}
		
		public function get_query() {
			return $this->_query;
		}
		
		protected function register_controls() {
			$this->start_controls_section(
				'section_content_layout',
				[
					'label' => esc_html__( 'Layout', 'ultimate-post-kit' ),
				]
			);

			$this->add_control(
				'grid_style',
				[
					'label'   => esc_html__( 'Layout Style', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '1',
					'options' => [
						'1' => esc_html__( 'Style 01', 'ultimate-post-kit' ),
						'2' => esc_html__( 'Style 02', 'ultimate-post-kit' ),
						'3' => esc_html__( 'Style 03', 'ultimate-post-kit' ),
					],
				]
			);
			
			$this->add_responsive_control(
				'columns',
				[
					'label' => __( 'Columns', 'ultimate-post-kit' ),
					'type' => Controls_Manager::SELECT,
					'default'        => '3',
					'tablet_default' => '2',
					'mobile_default' => '1',
					'options' => [
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					],
					'condition'      => [
						'grid_style' => [ '2', '3' ]
					],
				]
			);

			$this->add_responsive_control(
				'row_gap',
				[
					'label'     => esc_html__( 'Row Gap', 'ultimate-post-kit' ) . BDTUPK_NC,
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 20,
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'column_gap',
				[
					'label'     => esc_html__( 'Column Gap', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'default'   => [
						'size' => 20,
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'content_position',
				[
					'label'   => __( 'Content Position', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::CHOOSE,
					'default' => 'left',
					'options' => [
						'left'   => [
							'title' => __( 'Left', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-center',
						],
						'right'  => [
							'title' => __( 'Right', 'ultimate-post-kit' ),
							'icon'  => 'eicon-h-align-right',
						],
					],
					'prefix_class' => 'upk-content--',
					'render_type' => 'template',
					'toggle' => false,
					'condition' => [
						'grid_style' => [ '1', '2' ]
					],
				]
			);
		
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name'    => 'primary_thumbnail',
					'exclude' => [ 'custom' ],
					'default' => 'medium',
				]
			);

			$this->end_controls_section();
			
			//New Query Builder Settings
			$this->start_controls_section(
				'section_post_query_builder',
				[
					'label' => __( 'Query', 'ultimate-post-kit' ),
					'tab' => Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'item_limit',
				[
					'label'     => esc_html__( 'Item Limit', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min'  => 0,
							'max'  => 20,
							'step' => 1
						],
					],
					'default'   => [
						'size' => 6,
					],
				]
			);
			
			$this->register_query_builder_controls();
			
			$this->end_controls_section();

			$this->start_controls_section(
				'section_content_additional',
				[
					'label' => esc_html__( 'Additional', 'ultimate-post-kit' ),
				]
			);

			//Global Title Controls
			$this->register_title_controls();

			$this->add_control(
				'show_excerpt',
				[
					'label'   => esc_html__( 'Show Text', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'excerpt_length',
				[
					'label'       => esc_html__( 'Text Limit', 'ultimate-post-kit' ),
					'description' => esc_html__( 'It\'s just work for main content, but not working with excerpt. If you set 0 so you will get full main content.', 'ultimate-post-kit' ),
					'type'        => Controls_Manager::NUMBER,
					'default'     => 30,
					'condition'   => [
						'show_excerpt' => 'yes'
					],
				]
			);
			
			$this->add_control(
				'strip_shortcode',
				[
					'label'     => esc_html__( 'Strip Shortcode', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'condition' => [
						'show_excerpt' => 'yes',
					],
				]
			);
			
			$this->add_control(
				'show_category',
				[
					'label'   => esc_html__( 'Category', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'separator' => 'before'
				]
			);

			$this->add_control(
				'show_author',
				[
					'label'     => esc_html__( 'Show Author', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'show_comments',
				[
					'label' => esc_html__( 'Show Comments', 'ultimate-post-kit' ),
					'type'  => Controls_Manager::SWITCHER,
				]
			);
			
			$this->add_control(
				'meta_separator',
				[
					'label'       => __( 'Separator', 'ultimate-post-kit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => '//',
					'label_block' => false,
				]
			);
			
			//Global Date Controls
			$this->register_date_controls();
			
			$this->add_control(
				'show_counter',
				[
					'label'     => esc_html__( 'Show Counter', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'default'   => 'yes',
					'separator' => 'before'
				]
			);

			$this->add_control(
				'show_pagination',
				[
					'label'     => esc_html__( 'Pagination', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SWITCHER,
					'separator' => 'before'
				]
			);
			
			$this->add_control(
				'global_link',
				[
					'label'        => __( 'Item Wrapper Link', 'ultimate-post-kit' ),
					'type'         => Controls_Manager::SWITCHER,
					'prefix_class' => 'upk-global-link-',
					'description'  => __( 'Be aware! When Item Wrapper Link activated then title link and read more link will not work', 'ultimate-post-kit' ),
				]
			);

			$this->end_controls_section();
			
			//Style
			$this->start_controls_section(
				'upk_section_style',
				[
					'label' => esc_html__( 'Items', 'ultimate-post-kit' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label'      => esc_html__('Padding', 'ultimate-post-kit'),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors'  => [
						'{{WRAPPER}} .upk-wixer-grid .upk-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .upk-wixer-grid .upk-img-wrap .upk-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'grid_style' => '3',
					],
				]
			);
			
			$this->start_controls_tabs( 'tabs_items_style' );
			
			$this->start_controls_tab(
				'tab_item_primary',
				[
					'label' => esc_html__( 'Primary', 'ultimate-post-kit' ),
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'      => 'item_primary_background',
					'selector'  => '{{WRAPPER}} .upk-wixer-grid .upk-content',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_item_secondary',
				[
					'label' => esc_html__( 'Secondary', 'ultimate-post-kit' ),
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'      => 'item_secondary_background',
					'selector'  => '{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-content',
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_title',
				[
					'label'     => esc_html__( 'Title', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_title' => 'yes',
					],
				]
			);
			
			$this->add_control(
				'title_style',
				[
					'label'   => esc_html__( 'Style', 'ultimate-post-kit' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'underline',
					'options' => [
						'underline'        => esc_html__( 'Underline', 'ultimate-post-kit' ),
						'middle-underline' => esc_html__( 'Middle Underline', 'ultimate-post-kit' ),
						'overline'         => esc_html__( 'Overline', 'ultimate-post-kit' ),
						'middle-overline'  => esc_html__( 'Middle Overline', 'ultimate-post-kit' ),
					],
				]
			);
			
			$this->add_responsive_control(
				'title_spacing',
				[
					'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-title' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-title',
				]
			);

			$this->start_controls_tabs( 'tabs_title_style' );
			
			$this->start_controls_tab(
				'tab_title_primary',
				[
					'label' => esc_html__( 'Primary', 'ultimate-post-kit' ),
				]
			);

			$this->add_control(
				'title_primary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-title a' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_control(
				'title_primary_hover_color',
				[
					'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-title a:hover' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'title_primary_text_shadow',
					'label'    => __( 'Text Shadow', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-title',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_title_secondary',
				[
					'label' => esc_html__( 'Secondary', 'ultimate-post-kit' ),
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_control(
				'title_secondary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-title a' => 'color: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);
			
			$this->add_control(
				'title_secondary_hover_color',
				[
					'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-title a:hover' => 'color: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Text_Shadow::get_type(),
				[
					'name'     => 'title_secondary_text_shadow',
					'label'    => __( 'Text Shadow', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-title',
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_text',
				[
					'label'     => esc_html__( 'Text', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_excerpt' => 'yes',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'text_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-text',
				]
			);
			
			$this->add_responsive_control(
				'text_margin',
				[
					'label'      => __( 'Margin', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-wixer-grid .upk-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);

			$this->start_controls_tabs( 'tabs_text_style' );
			
			$this->start_controls_tab(
				'tab_text_primary',
				[
					'label' => esc_html__( 'Primary', 'ultimate-post-kit' ),
				]
			);

			$this->add_control(
				'text_primary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-text' => 'color: {{VALUE}};',
					],
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_text_secondary',
				[
					'label' => esc_html__( 'Secondary', 'ultimate-post-kit' ),
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_control(
				'text_secondary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-text' => 'color: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();
			
			$this->start_controls_section(
				'section_style_meta',
				[
					'label'      => esc_html__( 'Meta', 'ultimate-post-kit' ),
					'tab'        => Controls_Manager::TAB_STYLE,
					'conditions' => [
						'relation' => 'or',
						'terms'    => [
							[
								'name'  => 'show_author',
								'value' => 'yes'
							],
							[
								'name'  => 'show_date',
								'value' => 'yes'
							],
							[
								'name'  => 'show_comments',
								'value' => 'yes'
							]
						]
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'meta_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-meta',
				]
			);
			
			$this->add_responsive_control(
				'meta_spacing',
				[
					'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-meta' => 'padding-top: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'meta_space_between',
				[
					'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-meta .upk-separator' => 'margin: 0 {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->start_controls_tabs( 'tabs_meta_style' );
			
			$this->start_controls_tab(
				'tab_meta_primary',
				[
					'label' => esc_html__( 'Primary', 'ultimate-post-kit' ),
				]
			);

			$this->add_control(
				'meta_primary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-meta, {{WRAPPER}} .upk-wixer-grid .upk-meta .upk-author-wrap .upk-author-name' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'meta_primary_hover_color',
				[
					'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-meta .upk-author-wrap .upk-author-name:hover' => 'color: {{VALUE}};',
					],
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_meta_secondary',
				[
					'label' => esc_html__( 'Secondary', 'ultimate-post-kit' ),
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_control(
				'meta_secondary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-meta, {{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-meta .upk-author-wrap .upk-author-name' => 'color: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_control(
				'meta_secondary_hover_color',
				[
					'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-meta .upk-author-wrap .upk-author-name:hover' => 'color: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();

			$this->start_controls_section(
				'section_style_category',
				[
					'label'     => esc_html__( 'Category', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_category' => 'yes'
					],
				]
			);
			
			$this->add_responsive_control(
				'category_bottom_spacing',
				[
					'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min'  => 0,
							'max'  => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->start_controls_tabs( 'tabs_category_style' );
			
			$this->start_controls_tab(
				'tab_category_normal',
				[
					'label' => esc_html__( 'Normal', 'ultimate-post-kit' ),
				]
			);
			
			$this->add_control(
				'category_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'category_background',
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-category a',
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'category_border',
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-category a',
				]
			);
			
			$this->add_responsive_control(
				'category_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'category_padding',
				[
					'label'      => esc_html__( 'Padding', 'ultimate-post-kit' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'category_space_between',
				[
					'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min'  => 0,
							'max'  => 50,
							'step' => 2,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a+a' => 'margin-left: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'category_shadow',
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-category a',
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'category_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-category a',
				]
			);
			
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'tab_category_hover',
				[
					'label'     => esc_html__( 'Hover', 'ultimate-post-kit' ),
					'condition' => [
						'show_category' => 'yes'
					]
				]
			);
			
			$this->add_control(
				'category_hover_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a:hover' => 'color: {{VALUE}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'category_hover_background',
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-category a:hover',
				]
			);
			
			$this->add_control(
				'category_hover_border_color',
				[
					'label'     => esc_html__( 'Border Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'condition' => [
						'category_border_border!' => '',
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-category a:hover' => 'border-color: {{VALUE}};',
					],
				]
			);
			
			$this->end_controls_tab();
			
			$this->end_controls_tabs();
			
			$this->end_controls_section();

			$this->start_controls_section(
				'section_style_counter',
				[
					'label'     => esc_html__( 'Counter', 'ultimate-post-kit' ),
					'tab'       => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_counter' => 'yes',
					],
				]
			);
			
			$this->add_responsive_control(
				'counter_space_between',
				[
					'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min'  => 10,
							'max'  => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-counter::after' => 'left: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'counter_typography',
					'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
					'selector' => '{{WRAPPER}} .upk-wixer-grid .upk-counter',
				]
			);

			$this->start_controls_tabs( 'tabs_counter_style' );
			
			$this->start_controls_tab(
				'tab_counter_primary',
				[
					'label' => esc_html__( 'Primary', 'ultimate-post-kit' ),
				]
			);

			$this->add_control(
				'counter_primary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-counter' => 'color: {{VALUE}};',
						'{{WRAPPER}} .upk-wixer-grid .upk-counter:after' => 'background: {{VALUE}};',
					],
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_counter_secondary',
				[
					'label' => esc_html__( 'Secondary', 'ultimate-post-kit' ),
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->add_control(
				'counter_secondary_color',
				[
					'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-counter' => 'color: {{VALUE}};',
						'{{WRAPPER}} .upk-wixer-grid .upk-item:nth-child(n+4) .upk-counter:after' => 'background: {{VALUE}};',
					],
					'condition'      => [
						'grid_style' => [ '1' ]
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();
			
			//Global Pagination Controls
			$this->register_pagination_controls();
		}
		
		/**
		 * Main query render for this widget
		 * @param $posts_per_page number item query limit
		 */
		public function query_posts( $posts_per_page ) {
			
			$default = $this->getGroupControlQueryArgs();
			if ( $posts_per_page ) {
				$args['posts_per_page'] = $posts_per_page;
				$args['paged']  = max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) );
			}
			$args         = array_merge( $default, $args );
			$this->_query = new WP_Query( $args );
		}

		public function render_author() {
			
			if ( ! $this->get_settings( 'show_author' ) ) {
				return;
			}
			?>
            <div class="upk-author-wrap">
                <span class="upk-by"><?php echo esc_html_x('by', 'Frontend', 'ultimate-post-kit') ?></span>
                <a class="upk-author-name" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ) ?>">
					<?php echo get_the_author() ?>
                </a>
            </div>
			<?php
		}
		
		public function render_comments( $id = 0 ) {
			
			if ( ! $this->get_settings( 'show_comments' ) ) {
				return;
			}
			?>

            <div class="upk-wixer-comments">
				<?php echo get_comments_number( $id ) ?>
				<?php echo esc_html_x( 'Comments', 'Frontend', 'ultimate-post-kit' ) ?>
            </div>
			
			<?php
		}
		
		public function render_post_grid_item( $post_id, $image_size, $excerpt_length, $slide_index ) {
			$settings = $this->get_settings_for_display();
			
			if ( 'yes' == $settings['global_link'] ) {
				
				$this->add_render_attribute( 'grid-item', 'onclick', "window.open('" . esc_url( get_permalink() ) . "', '_self')", true );
			}
			
			$this->add_render_attribute( 'grid-item', 'class', 'upk-item', true );
			
			?>

			<div <?php $this->print_render_attribute_string( 'grid-item' ); ?>>
				<div class="upk-item-box">
					<?php if ( '3' != $settings['grid_style']) : ?>
					<div class="upk-img-wrap">
						<?php $this->render_image( get_post_thumbnail_id( $post_id ), $image_size ); ?>
						<?php $this->render_category(); ?>
					</div>
					<?php endif; ?>

					<div class="upk-content">
					<div class="upk-content-wrap">
						<?php $this->render_category(); ?>

						<?php if ( $settings['show_author'] or $settings['show_comments'] or $settings['show_date'] ) : ?>
							<div class="upk-meta">
								<?php if ( $settings['show_author'] ) : ?>
									<?php $this->render_author(); ?>
									<span class="upk-separator"><?php echo $settings['meta_separator']; ?></span>
								<?php endif; ?>
								<?php $this->render_date(); ?>
								<?php if ( $settings['show_comments'] ) : ?>
									<span class="upk-separator"><?php echo $settings['meta_separator']; ?></span>
									<?php $this->render_comments( $post_id ); ?>
								<?php endif; ?>
							</div>
						<?php endif; ?>

						<?php $this->render_title(); ?>

						<?php $this->render_excerpt( $excerpt_length ); ?>

						<?php if ($settings['show_counter'] == 'yes') : ?>
							<div class="upk-counter"><?php printf("%02d", $slide_index); ?></div>
						<?php endif; ?>

					</div>
					</div>
				</div>
			</div>
			<?php
		}
		
		protected function render() {
			$settings = $this->get_settings_for_display();
			
			$this->query_posts( $settings['item_limit']['size'] );
			
			$wp_query = $this->get_query();
			
			if ( ! $wp_query->found_posts ) {
				return;
			}

			$this->add_render_attribute( 'grid-wrap', 'class', 'upk-wixer-grid upk-style-' . $settings['grid_style'] );
			
			if (isset($settings['upk_in_animation_show']) && ($settings['upk_in_animation_show'] == 'yes')) {
				$this->add_render_attribute( 'grid-wrap', 'class', 'upk-in-animation' );
				if (isset($settings['upk_in_animation_delay']['size'])) {
					$this->add_render_attribute( 'grid-wrap', 'data-in-animation-delay', $settings['upk_in_animation_delay']['size'] );
				}
			}
			
			?>
            <div <?php $this->print_render_attribute_string('grid-wrap'); ?>>
				<?php 
				$slide_index = 1;
				while ( $wp_query->have_posts() ) :
					$wp_query->the_post();
					
					$thumbnail_size = $settings['primary_thumbnail_size'];
					
					?>
					
					<?php $this->render_post_grid_item( get_the_ID(), $thumbnail_size,  $settings['excerpt_length'], $slide_index ); 
					$slide_index++;
					?>
				
				<?php endwhile; ?>
            </div>
			
			<?php
			
			if ( $settings['show_pagination'] ) { ?>
                <div class="ep-pagination">
					<?php ultimate_post_kit_post_pagination( $wp_query, $this->get_id() ); ?>
                </div>
				<?php
			}
			wp_reset_postdata();
		}
	}
